/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275d;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class VlanPortCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8275d.GeneralResources");
    public static final int RASID = 19;
    public static final int RASSUB = 8;
    DestinationPropBook myBook;
    JdmBrowser browser;
    NavigationContext myContext;
    MessageBox messageToUser;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        boolean bl = true;
        GenModel genModel = null;
        ModelInfo modelInfo = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        String string = null;
        String string2 = "proceed";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string2);
        }
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string2, "Can't get browser- can't proceed with create");
            }
            bl = false;
        }
        if (bl) {
            Hashtable hashtable = jDMWizardInfo.getItems();
            genModel = jDMWizardInfo.getModel();
            try {
                n = (Integer)hashtable.get("newVlan");
                n2 = (Integer)hashtable.get("newSlot");
                n3 = (Integer)hashtable.get("newPort");
                if (n == 0 || n2 == 0 || n3 == 0) {
                    if (RAS.isEnabled(19, 8)) {
                        RAS.trace(19, 8, this, string2, "Invalid user data- can't create row");
                    }
                    string = new String("VPC_invalidInput");
                    bl = false;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "unexpected/missing user data- can't create row");
                }
                string = new String("VPC_invalidInput");
                bl = false;
            }
        }
        if (bl) {
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Vlan", n);
            modelInfo.add("Index.Slot", n2);
            modelInfo.add("Index.Port", n3);
            modelInfo.add("Panel.PortCommand", new Integer(1));
            try {
                modelInfo = genModel.setInfo("Panel", modelInfo);
                bl = this.checkSnmpResponse(modelInfo);
                string = new String("VPC_badSet");
            }
            catch (Exception exception) {
                bl = false;
                string = new String("VPC_badSetServer");
                if (RAS.isEnabled(19, 8)) {
                    RAS.trace(19, 8, this, string2, "Exception inserting Port into Vlan");
                }
                RAS.logException(19, 8, this, string2, exception);
            }
        }
        if (!bl && this.browser != null) {
            this.browser.displayMsg(VlanPortCreate.getNLSString(string));
            this.messageToUser = new MessageBox(this.browser.getFrame(), VlanPortCreate.getNLSString("VPC_error"), VlanPortCreate.getNLSString(string), true);
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string2);
        }
        return bl;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        String string = "checkSnmpResponse";
        if (RAS.isEnabled(19, 8)) {
            RAS.enter(19, 8, this, string);
        }
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string2 = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string2);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 8)) {
                RAS.trace(19, 8, this, string, "DL: Error in snmp set. Variable is " + string2 + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        if (RAS.isEnabled(19, 8)) {
            RAS.exit(19, 8, this, string);
        }
        return bl;
    }
}

